/***************************************************************************

    Faxcoder : Usage faxcoder <fax_file.fax >output

    This program compresses a fax using a model based on an order 16 model.
    Context is as follows : x = Context bits, P = bit being predicted
   
	  			   x
				xxxxxx
				xxxxxx
				xxxP
 
   Variable names beginning with capital letters are arithmetic coding
   variables used by the arithmetic coding routines.

			-------------------------------

   Copyright Raymond P. Wilson 1989.

   This program is a shareware program. If you use it then credit must be
   given to the author (me). If you find this program useful please send
   whatever you think it is worth ($25 is suggested) to :

			Raymond P. Wilson
			38 Paremata St
			Atawhai
			Nelson
			New Zealand

    If you want to use this or parts of this program in a commercial product
 then the authors permission is required.

 **************************************************************************/
 
#include <stdio.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "coderdef.i"	    /* My faxcoder definitions etc... */
#include "arithcod.i"	/* Arithmetic coding functions and defs... */

/*************************************************************************

   Function   : Initialise_model
   Parameters : None
   Returns    : Nothing

   Initialise_model sets up all the structures and initialisation
 required by the fax coder. 

 ************************************************************************/

void initialise_model()
{
   int i;

   /* Initialise context bits and saved context arrays */
  
   for (i = 0;i < CONTEXT_WINDOW_BPL;i++)
      saved[i] = 0;

   /* Initialise context information array */
  
   for (i = 0;i < NUM_CONTEXTS;i++)
   {
      contexts[i].zero_count = 1;
      contexts[i].sum = 2;
   }
}

/************************************************************************

   Function   : Compress
   Parameters : None
   Returns    : Nothing
   
   Compress compresses a fax file read in from std input.
   
 ***********************************************************************/
 
void compress()
{
   register codevalue	S_low=0, S_high=0;
 		    /* Arithmetic coder vars high and low of range */
   register int 
      context,      /* Context at predicted bit */
      bitnum,       /* Bit being compressed on current line */
      S_bitstogo,   /* Arithmetic coder var - used in inputting bits */
      H = half,     /* Arithmetic coder var - contains constant half */
      last,         /* Shifting three bit field of last three bits read in */
      mask = 0,     /* Mask for getting bit out of byte */
      byte = 0;     /* Byte read in from  */
      
   startoutputingbits();
   startencoding();
  
   for (line = 0;line < NUM_LINES;line++)
   {
      last = 0;   /* Clear shifting temporary storage for incoming bits */

    /* Start iterating over bits in line - start in from edge of 'sheet'
       to give white space at edge for context */
       
      for (bitnum = CONTEXT_SIDE_BITS;
           bitnum < (CONTEXT_SIDE_BITS + BITS_PER_LINE);bitnum++)
      {
      
    /* Work out context that precedes bit being predicted */
   
         context = saved[bitnum] | (last >> 3);
                   
    /* Store that part of the context that will be used on to the next line */ 
 
         saved[bitnum] = (context & CONTEXT_MASK) << 6;
    
     /* Get the bit that is to be compressed */
    
         getabit()
         
    /* Code the bit currently being compressed and update the model */
   	
         if (byte & mask)
         {
            arithmetic_encode_one(contexts[context].zero_count,
                                  contexts[context].sum)
                                  
       /* Add a one bit to shifting storage and add this to previously
          stored context from two bits back */
                                        
            saved[bitnum-2] |= (last = ((last << 1) | 0x8) & 0x38);
         }
         else
         {
            arithmetic_encode_zero(contexts[context].zero_count,
                                   contexts[context].sum);

       /* Add a zero bit to shifting storage and add this to previously
          stored context from two bits back */

            saved[bitnum-2] |= (last = (last << 1) & 0x38);
            
            contexts[context].zero_count++; /* Increment zero bit count */
         }

       /* Increment sum count and check to see if counts need halving */
       
         if ((++contexts[context].sum) == HALVE_LIMIT)  
         {
            contexts[context].zero_count = (contexts[context].zero_count >> 2) + 1;
            contexts[context].sum = (contexts[context].sum >> 2) + 2;
         }
      }
   }
   /* Finish up encoding and finishing outputting bits */
   doneencoding();
   doneoutputingbits();
}

/*************************************************************************

                                 Main program.
   
 ************************************************************************/
 
main(argc, argv)
int argc;
char **argv;
{
   initialise_model();
   fprintf(stderr,"Compressing file, please wait...\n\n");
   start_time = get_time();             /* Get starting time */
   compress();
   total_time = get_time() - start_time; /* Get total time from difference */
   fprintf(stderr,"%s: compression %4.2f bpc (%4.2f : 1) in %.3f seconds.\n",
                  argv[0], (8 * cmpbytes)/(double)FAX_SIZE,
                  FAX_SIZE/(float)cmpbytes, total_time);
   exit(0);
}
